
BlendState AdditiveBlend {
	BlendEnable[0] = True;
	BlendOpAlpha = ADD;
	BlendOp = ADD;
	DestBlendAlpha = ONE;
	DestBlend = ONE;
	AlphaToCoverageEnable = False;
	SrcBlendAlpha = ZERO;
	SrcBlend = ONE;
	RenderTargetWriteMask[0] = 7; // don't update the alpha component because espen store geometry z/w in that component
};

BlendState SolidBlend {
	BlendEnable[0] = False;
};

DepthStencilState DepthOn
{
	DepthEnable = TRUE;
	DepthWriteMask = ALL;
};

DepthStencilState DepthOff
{
	DepthEnable = FALSE;
	DepthWriteMask = ZERO;
};

DepthStencilState DepthWriteOff
{
	DepthEnable = TRUE;
	DepthWriteMask = ZERO;
};

RasterizerState rasterizerState {
	FillMode = Solid;
	CullMode = None;
	FrontCounterClockwise = FALSE;
	DepthBias = 0;
	SlopeScaledDepthBias = 0.0f;
	DepthBiasClamp = 0.0f;
	DepthClipEnable = TRUE;
	ScissorEnable =	FALSE;
	MultisampleEnable = FALSE;
	AntialiasedLineEnable = FALSE;
};

RasterizerState alwaysDraw {
	FillMode = Solid;
	CullMode = None;
	FrontCounterClockwise = FALSE;
	DepthBias = 0;
	SlopeScaledDepthBias = 0.0f;
	DepthBiasClamp = 0.0f;
	DepthClipEnable = FALSE;
	ScissorEnable =	FALSE;
	MultisampleEnable = FALSE;
	AntialiasedLineEnable = FALSE;
};

RasterizerState letsDoSomeCullingOK {
	FillMode = Solid;
	CullMode = Back;
	FrontCounterClockwise = FALSE;
	DepthBias = 0;
	SlopeScaledDepthBias = 0.0f;
	DepthBiasClamp = 0.0f;
	DepthClipEnable = TRUE;
	ScissorEnable = FALSE;
	MultisampleEnable = FALSE;
	AntialiasedLineEnable = FALSE;
};

cbuffer ConstantBuffer /*: register( b0 )*/
{
	Matrix ModelViewProjectionMatrix;
	Matrix ModelViewMatrix;
	float4 billUp;
	float4 billRight;
	float4 timeAmpRtwRth;
	float4 nearFarZ;
	float4 scaleBias;
	float4 sunBlurOverlay;
}

Texture2D tex;
Texture2D tex2;
Texture2D tex3;
Texture2D tex4;
Texture2D tex5;

SamplerState TexSmp {
	Filter = MIN_MAG_MIP_LINEAR;
	AddressU = Clamp;
	AddressV = Clamp;
};

SamplerState TexSmpRepeat {
	Filter = MIN_MAG_MIP_LINEAR;
	AddressU = Wrap;
	AddressV = Wrap;
};

SamplerState TexSmpPointRepeat {
	Filter = MIN_MAG_MIP_POINT;
	AddressU = Wrap;
	AddressV = Wrap;
};

struct VS_IN
{
	float3 pos : POSITION;
	float2 uv : TEXCOORD;
};

struct PS_IN
{
	float4 pos : SV_POSITION;
	float2 uv : TEXCOORD;
};

PS_IN VSParticles( VS_IN input, uint vi : SV_VertexID )
{
	PS_IN output = (PS_IN)0;
	uint vi2 = vi>>2;
	float vid = -float(vi2)/20.0f;
	float s = 0.145+sin( timeAmpRtwRth.x + vid) * (float(vi2 & 0x3f)/300.0f);
	float4 pos = float4(input.pos,1.0f);
		pos += float4( sin( timeAmpRtwRth.x + cos(vid)*1.1f ) * timeAmpRtwRth.y*0.5f,
		cos(timeAmpRtwRth.x*1.02 + sin(vid)*1.5f)*timeAmpRtwRth.y*5.2f,
		sin( timeAmpRtwRth.x*0.5 + cos(vid)*1.5f ) * timeAmpRtwRth.y*1.5f, 0.0f)*0.05f;

	output.pos = mul( ModelViewProjectionMatrix, pos + (input.uv.x * billUp * 0.5 + input.uv.y * billRight * 0.5)*s );
	output.uv = input.uv;
	return output;
}

struct VSE_IN
{
	float3 pos : POSITION;
	float2 uv : TEXCOORD;
	float3 params : NORMAL; // impact time, tile index, size
	float4 color : COLOR;
};

struct PSE_IN
{
	float4 pos : SV_POSITION;
	float4 params : TEXCOORD;
	float4 color : COLOR;
};

PSE_IN VSExplosions( VSE_IN input, uint vi : SV_VertexID )
{
	float2 quad[4] = {
		float2(-1.0, -1.0),
		float2( 1.0, -1.0),
		float2(-1.0,  1.0),
		float2( 1.0,  1.0)
	};

	PSE_IN output = (PSE_IN)0;
	uint index = vi % 4;

	float time = timeAmpRtwRth.x - input.params.x;
	float scale = input.params.z * smoothstep(0.0, 0.02, time);

	float4 pos = float4(input.pos, 1.0f);

		pos.xyz += (billRight*quad[index].x + billUp*quad[index].y) * scale;
	//		pos.xyz += (billRight.xyz*quad[index].x + billUp.xyz*quad[index].y) * scale;

	output.pos = mul( ModelViewProjectionMatrix, pos );

	output.pos = mul(ModelViewProjectionMatrix, pos);
	output.params.xy = input.uv;
	output.params.z = time * 0.75; // animation speed
	output.params.w = input.params.y / 8.0;
	output.color = input.color;
	return output;
}

float4 PSExplosions(PSE_IN input, float4 screenPos : SV_Position  ) : SV_Target
{
	float2 tileSize = float2(64.0/1024.0, 64.0/512.0);
		float2 tileUV = input.params.zw;
		tileUV.x = clamp(floor(tileUV.x * 16.0) / 16.0, 0.0, 1.0);
	tileUV += input.params.xy * tileSize;
	//		float4 c = tex.Sample(TexSmp, tileUV);
	//		c.rgb *= float3(1.0, 1.0, 2.0);
	float4 c = tex.Sample(TexSmp, tileUV) * input.color;
		c.rgb *= c.a;
	return c;
}

float s2lin(float x)
{
	float a = 0.055f;
	if ( x <= 0.04045f )
	{
		return x * (1.0f / 12.92f);
	}
	return pow( (x + a) * (1.0f / (1.0f + a)), 2.4f);
}

float lin2s(float x)
{
	float a = 0.055;
	if ( x <= 0.031308f )
	{
		return x * 12.92f;
	}
	return (1.0f + a) * pow(x, 1.0f / 2.4f) - a;
}

PS_IN VS( VS_IN input )
{
	PS_IN output = (PS_IN)0;
	output.pos = mul( ModelViewProjectionMatrix, float4( input.pos, 1.0f) );
	output.uv = input.uv;
	return output;
}

float4 PS( PS_IN input, float4 screenPos : SV_Position  ) : SV_Target
{
	float4 c = tex.Sample(TexSmp, input.uv);
		//c.a = length( c.rgb );
		c.rgb *= float3( 1.5f, 1.6f, 1.0f );
	c.a = screenPos.z/screenPos.w;
	return c;
}

float4 PSOverlay( PS_IN input, float4 screenPos : SV_Position  ) : SV_Target
{
	float4 c = tex.Sample(TexSmp, input.uv)*sunBlurOverlay.z;
	c.rgb *= float3( 5.5f, 4.25f, 3.0f );
	c.a = screenPos.z/screenPos.w;
	return c;
}


float4 PSParticles( PS_IN input, float4 screenPos : SV_Position  ) : SV_Target
{
	float4 c = tex.Sample(TexSmp, input.uv);
		//c.a = length( c.rgb );
	c.rgb *= float3( 8.5f, 7.8f, 8.0f );
	c.a = 0.0f;
	return c;
}

float4 PSScroller( PS_IN input ) : SV_Target
{
	return float4(1.0f,0.25f,0.0f, 1.0f);
}

/*
final  = texture(tex, uv - 3.0*TexelSize)*0.06;
final += texture(tex, uv - 2.0*TexelSize)*0.125;
final += texture(tex, uv - 1.0*TexelSize)*0.1875;
final += texture(tex, uv                )*0.25;
final += texture(tex, uv + 1.0*TexelSize)*0.1875;
final += texture(tex, uv + 2.0*TexelSize)*0.125;
final += texture(tex, uv + 3.0*TexelSize)*0.06;
*/

#define NS 14.0f
#define MUL 2.0f
#define NSI 7

float4 PSSeparableGlowH( PS_IN input ) : SV_Target
{
	float tz = 1.0f/timeAmpRtwRth.z;
	float arr[7] = { 0.06f, 0.125f, 0.1875f, 0.25f, 0.1875f, 0.125f, 0.06f };
	float4 c = float4( 0.0f, 0.0f, 0.0f, 0.0f );
		float w = input.uv.x-(3.0f*tz);
	float h = input.uv.y;
	for ( int i = 0; i<NSI; i++ )
	{
		c += arr[i]*tex.Sample(TexSmp, float2(w,h));
		w += tz;
	}
	return c;
}

float4 PSSeparableGlowV( PS_IN input ) : SV_Target
{
	float tz = 1.0f/timeAmpRtwRth.w;
	float arr[7] = { 0.06f, 0.125f, 0.1875f, 0.25f, 0.1875f, 0.125f, 0.06f };
	float4 c = float4( 0.0f, 0.0f, 0.0f, 0.0f );
		float w = input.uv.x;
	float h = input.uv.y-(3.0f*tz);
	for ( int i = 0; i<NSI; i++ )
	{
		c += arr[i]*tex.Sample(TexSmp, float2(w,h));
		h += tz;
	}
	return c;
}

float4 PSSeparableGlowDownSample( PS_IN input ) : SV_Target
{
	float tzx = 1.0f/timeAmpRtwRth.z;
	float tzy = 1.0f/timeAmpRtwRth.w;
	float oy = -2.0f*tzy+0.5f*tzy;
	float4 c = float4( 0.0f,0.0f,0.0f,0.0f );
		for ( int j = 0; j<2 ; j++ )
		{
			float ox = -2.0f*tzx+0.5f*tzx;
			for ( int i = 0; i<2 ; i++ )
			{
				float4 g = tex.Sample(TexSmp, input.uv + float2(ox,oy));
					c += float4( g.rgb, 1.0f) ;
				ox += tzx*2.0f;
			}
			oy += tzy*2.0f;
		}
		return c/4.0f;
}

// xxxxxxxx
float4 PSSeparableGlowLastPass( PS_IN input ) : SV_Target
{
	float4 c = tex.Sample(TexSmp, input.uv); // -0.4f;
		return c;
}

#if 1
//
float linearizeDepth(float d)
{
	float nearZ = 1.0;
	float farZ = 100.0;
	//return 2.0*nearZ / (farZ + nearZ - (1.0 - d)*farZ - nearZ);
	return 1.0 - (2.0*nearZ / (farZ + nearZ - d*farZ - nearZ));
	//return d;
}

float linearizeDepthSample(float2 uv)
{
	float nearZ = 1.0;
	float farZ = 100.0;
	float d = tex4.Sample(TexSmp, uv).x;
	//return 2.0*nearZ / (farZ + nearZ - (1.0 - d)*farZ - nearZ);
	return 1.0 - (2.0*nearZ / (farZ + nearZ - d*farZ - nearZ));
	//return d;
}

// find edge from depth values
float edgeDetection(float2 uv)
{
	float2 texelSize = float2(1.0f/timeAmpRtwRth.z, 1.0f/timeAmpRtwRth.w);

	float currentDepth = linearizeDepthSample(uv);
	float edgeDiff = 0.0;
	edgeDiff += abs( linearizeDepthSample(uv + float2(-texelSize.x,  texelSize.y)) - currentDepth );
	edgeDiff += abs( linearizeDepthSample(uv + float2(         0.0,  texelSize.y)) - currentDepth );
	edgeDiff += abs( linearizeDepthSample(uv + float2( texelSize.x,  texelSize.y)) - currentDepth );
	edgeDiff += abs( linearizeDepthSample(uv + float2(-texelSize.x,          0.0)) - currentDepth );
	edgeDiff += abs( linearizeDepthSample(uv + float2(         0.0,          0.0)) - currentDepth );
	edgeDiff += abs( linearizeDepthSample(uv + float2( texelSize.x,          0.0)) - currentDepth );
	edgeDiff += abs( linearizeDepthSample(uv + float2(-texelSize.x, -texelSize.y)) - currentDepth );
	edgeDiff += abs( linearizeDepthSample(uv + float2(         0.0, -texelSize.y)) - currentDepth );
	edgeDiff += abs( linearizeDepthSample(uv + float2( texelSize.x, -texelSize.y)) - currentDepth );

	float magnitudeScale = 16.0;//16.0;
	float magnitudeThreshold = 1.0 / magnitudeScale;
	float magnitude = edgeDiff * magnitudeScale;
	magnitude = smoothstep(magnitudeThreshold + 0.1, 0.3, magnitude);
	return magnitude;
}

// fake amb. occ.
float fakeSSAO(float2 uv)
{
	float3 sphere[16] = {
		float3(0.53812504, 0.18565957, -0.43192),
		float3(0.13790712, 0.24864247, 0.44301823),
		float3(0.33715037, 0.56794053, -0.005789503),
		float3(-0.6999805, -0.04511441, -0.0019965635),
		float3(0.06896307, -0.15983082, -0.85477847),
		float3(0.056099437, 0.006954967, -0.1843352),
		float3(-0.014653638, 0.14027752, 0.0762037),
		float3(0.010019933, -0.1924225, -0.034443386),
		float3(-0.35775623, -0.5301969, -0.43581226),
		float3(-0.3169221, 0.106360726, 0.015860917),
		float3(0.010350345, -0.58698344, 0.0046293875),
		float3(-0.08972908, -0.49408212, 0.3287904),
		float3(0.7119986, -0.0154690035, -0.09183723),
		float3(-0.053382345, 0.059675813, -0.5411899),
		float3(0.035267662, -0.063188605, 0.54602677),
		float3(-0.47761092, 0.2847911, -0.0271716)
	};

	float2 texelSize = float2(1.0f/timeAmpRtwRth.z, 1.0f/timeAmpRtwRth.w);
	//	float3 norm = normalize(tex5.Sample(TexSmpPointRepeat, uv*64.0).xyz*2.0 - 1.0);
	//	float currentDepth = linearizeDepthSample(uv);
	//float radius = max(16.0 / currentDepth, 4.0);
	float3 norm = normalize(tex5.Sample(TexSmpPointRepeat, uv*64.0).xyz*2.0 - 1.0);
	float currentDepth = linearizeDepthSample(uv);
	float radius = max(16.0 / currentDepth, 2.0);
	float ssao = 0.0;
	for (int i=0; i < 16; i++)
	{
		float2 ray = normalize(reflect(norm, sphere[i])).xy;
			float2 offset = uv + ray.xy * texelSize * radius * (float(i+1)*(1.0/16.0));

			float d = linearizeDepthSample(offset);
		float diff = (d - currentDepth) * 250.0;
		ssao += smoothstep(0.0, 1.0, diff);
	}

	return pow(1.0 - (ssao / 16.0), 4.0);
}

float4 theUsual( PS_IN input )
{
	// NOTE - the uv offset should be weighted with z to get rid of the moire/noise you get with small/distant objects
	float2 uv = input.uv + (tex3.Sample(TexSmpRepeat, input.uv*0.21 + timeAmpRtwRth.xx*0.01).xy*0.2 - 0.1)*0.0005;

	float ux = 1.0f / timeAmpRtwRth.z;
	float uy = 1.0f / timeAmpRtwRth.w;
	float2 u = float2(0.5f*ux, 0.5f*uy);

	float4 sharp = tex2.Sample(TexSmp, input.uv)*0.5 + tex2.Sample(TexSmp, uv + u)*0.5;
	float4 blur = tex.Sample(TexSmp, input.uv)*0.5 + tex.Sample(TexSmp, uv)*0.5;

	float4 glow = blur;
	glow.xyz -= float3(0.24f,0.245f,0.25f)*2.45f;
	if ( glow.x < 0.0f ) glow.x *= 0.8f;
	if ( glow.y < 0.0f ) glow.y *= 0.78f;
	if ( glow.z < 0.0f ) glow.z *= 0.79f;
	glow.xyz *= float3( 1.15f,1.05f,1.0f )*2.45f;
	glow.xyz += float3(0.24f,0.245f,0.25f)*2.65f;

	float4 noise = tex3.Sample(TexSmpRepeat, (input.uv+float2(timeAmpRtwRth.x*3.1, timeAmpRtwRth.x*0.1 ))); // noise
	float4 noise2 = tex3.Sample(TexSmpRepeat, (input.uv+float2(timeAmpRtwRth.x*3.2, timeAmpRtwRth.x*0.3 ))); // noise

	//float magnitude = edgeDetection(input.uv);
	float ssao = fakeSSAO(input.uv);
	// make ssao depend on glow intensity
	// ssao = ssao + (1.0 - ssao) * smoothstep(0.75, 1.0, length(glow.xyz));

	// TODO - use a constant to control where we get the defocus effect (eg something like uv2 = (input.uv - defocusCenter)*2.0 - 1.0)
	float2 uv2 = input.uv*2.0 - 1.0;
	// blend between sharp and blurred based on distance from screen center
	// NOTE - if we want to add more control we can take scene depth into account
	float blend = sunBlurOverlay.y; // smoothstep(0.0, 0.4, dot(uv2, uv2));

	float4 c;
	c.xyz = sharp.xyz;
	c.xyz *= (1.0f-ssao*1.5f)/2.0f + 0.5f;
	c.xyz *= (ssao) + 0.30f;
	c.xyz = c.xyz * blend + blur.xyz*(1.0 - blend);// + magnitude*0.25;
	c.w = 1.0f;
	c.xyz += glow.xyz*0.35f + (glow.xyz * noise.xyz)*0.10f;

#define NEG 0.48f /*155f*/
	c.xyz -= float3(NEG,NEG,NEG);
	c.xyz *= 0.50f/(1.00-NEG);
	c.rgb *= scaleBias.rgb;
	c.rgb += float3(scaleBias.aaa);
	//c.rgb = float3(ssao, ssao, ssao);
	return c;
}


float4 PSPostProcess_testing( PS_IN input ) : SV_Target
{
	return theUsual( input );
/*
	// NOTE - the uv offset should be weighted with z to get rid of the moire/noise you get with small/distant objects
	float2 uv = input.uv + (tex3.Sample(TexSmpRepeat, input.uv*0.21 + timeAmpRtwRth.xx*0.01).xy*0.2 - 0.1)*0.0005;

	float ux = 1.0f / timeAmpRtwRth.z;
	float uy = 1.0f / timeAmpRtwRth.w;
	float2 u = float2(0.5f*ux, 0.5f*uy);

	float4 sharp = tex2.Sample(TexSmp, input.uv)*0.5 + tex2.Sample(TexSmp, uv + u)*0.5;
	float4 blur = tex.Sample(TexSmp, input.uv)*0.5 + tex.Sample(TexSmp, uv)*0.5;

	float4 glow = blur;
	glow.xyz -= float3(0.24f,0.245f,0.25f)*2.45f;
	if ( glow.x < 0.0f ) glow.x *= 0.8f;
	if ( glow.y < 0.0f ) glow.y *= 0.78f;
	if ( glow.z < 0.0f ) glow.z *= 0.79f;
	glow.xyz *= float3( 1.15f,1.05f,1.0f )*2.45f;
	glow.xyz += float3(0.24f,0.245f,0.25f)*2.65f;

	float4 noise = tex3.Sample(TexSmpRepeat, (input.uv+float2(timeAmpRtwRth.x*3.1, timeAmpRtwRth.x*0.1 ))); // noise
	float4 noise2 = tex3.Sample(TexSmpRepeat, (input.uv+float2(timeAmpRtwRth.x*3.2, timeAmpRtwRth.x*0.3 ))); // noise

	//float magnitude = edgeDetection(input.uv);
	float ssao = fakeSSAO(input.uv);
	// make ssao depend on glow intensity
	// ssao = ssao + (1.0 - ssao) * smoothstep(0.75, 1.0, length(glow.xyz));

	// TODO - use a constant to control where we get the defocus effect (eg something like uv2 = (input.uv - defocusCenter)*2.0 - 1.0)
	float2 uv2 = input.uv*2.0 - 1.0;
	// blend between sharp and blurred based on distance from screen center
	// NOTE - if we want to add more control we can take scene depth into account
	float blend = sunBlurOverlay.y; // smoothstep(0.0, 0.4, dot(uv2, uv2));

	float4 c;
	c.xyz = sharp.xyz;
	c.xyz *= (1.0f-ssao*1.5f)/2.0f + 0.5f;
	c.xyz *= (ssao) + 0.30f;
	c.xyz = c.xyz * blend + blur.xyz*(1.0 - blend);// + magnitude*0.25;
	c.w = 1.0f;
	c.xyz += glow.xyz*0.35f + (glow.xyz * noise.xyz)*0.10f;

#define NEG 0.45f /*155f*/
/*	c.xyz -= float3(NEG,NEG,NEG);
	c.xyz *= 0.50f/(1.00-NEG);
	c.rgb *= scaleBias.rgb;
	c.rgb += float3(scaleBias.aaa);
	//c.rgb = float3(ssao, ssao, ssao);
	return c;
*/
}



float4 PSPostProcess_grey( PS_IN input ) : SV_Target
{
	float3 yo = length(theUsual( input ).xyz);
	return float4(yo.x*0.25f,yo.x*0.24f,yo.x*0.25f,1.0f);
}


float4 PSPostProcess_outline( PS_IN input, float4 screenPos : SV_Position ) : SV_Target
{
	// NOTE - the uv offset should be weighted with z to get rid of the moire/noise you get with small/distant objects
	float2 uv = input.uv + (tex3.Sample(TexSmpRepeat, input.uv*0.21 + timeAmpRtwRth.xx*0.01).xy*0.2 - 0.1)*0.0005;

	float ux = 1.0f / timeAmpRtwRth.z;
	float uy = 1.0f / timeAmpRtwRth.w;
	float2 u = float2(0.5f*ux, 0.5f*uy);

	float4 sharp = tex2.Sample(TexSmp, input.uv)*0.5 + tex2.Sample(TexSmp, uv + u)*0.5;
	float4 blur = tex.Sample(TexSmp, input.uv)*0.5 + tex.Sample(TexSmp, uv)*0.5;

	float4 glow = blur;

	float4 noise = tex3.Sample(TexSmpRepeat, (input.uv+float2(timeAmpRtwRth.x*3.1, timeAmpRtwRth.x*0.1 ))); // noise

	// float ssao = 1.0f-edgeDetection(input.uv);
	float ssao = fakeSSAO(input.uv);
	// make ssao depend on glow intensity
	// ssao = ssao + (1.0 - ssao) * smoothstep(0.75, 1.0, length(glow.xyz));

	// TODO - use a constant to control where we get the defocus effect (eg something like uv2 = (input.uv - defocusCenter)*2.0 - 1.0)
	float2 uv2 = input.uv*2.0 - 1.0;
	// blend between sharp and blurred based on distance from screen center
	// NOTE - if we want to add more control we can take scene depth into account
	float blend = 1.0f-smoothstep(0.0, 1.0, sqrt(dot(uv2, uv2)));

	float technostripes = (float)abs(sin(input.uv.y*350.0f))*0.125f+0.875f;
	float scanningbeam = (float)sin(input.uv.y+timeAmpRtwRth.x*1.5f)*0.5f;

	float4 c;
	c.xyz = sharp.xyz;
	c.xyz *= 2.0f-ssao*2.0f;
	c.xyz += ssao*0.25f;
	c.xyz = c.xyz * blend + blur.xyz*(1.0 - blend);// + magnitude*0.25;
	c.w = 1.0f;
	c.xyz = length(c.xyz)*(blend+0.5f)*technostripes;
	c.xyz += glow.xyz*0.125f + (glow.xyz * noise.xyz)*0.25f;
	c.xyz *= float3(1.0f,0.5f,0.25f)*input.uv.y+float3(0.55f,0.75f,0.75f)*(1.0f-input.uv.y);
	c.xyz += scanningbeam*float3(0.5f,0.4f,0.6f)*2.0f;
#define NEG 0.75f /*155f*/
	c.xyz -= float3(NEG,NEG,NEG);
	c.xyz *= 0.35f/(1.00-NEG);
	c.rgb *= scaleBias.rgb;
	c.rgb += float3(scaleBias.aaa);

	//c.rgb = float3(ssao, ssao, ssao);
	return c;
}


float4 blurBackbuffer(float2 uv)
{
	float3 sphere[16] = {
		float3(0.53812504, 0.18565957, -0.43192),
		float3(0.13790712, 0.24864247, 0.44301823),
		float3(0.33715037, 0.56794053, -0.005789503),
		float3(-0.6999805, -0.04511441, -0.0019965635),
		float3(0.06896307, -0.15983082, -0.85477847),
		float3(0.056099437, 0.006954967, -0.1843352),
		float3(-0.014653638, 0.14027752, 0.0762037),
		float3(0.010019933, -0.1924225, -0.034443386),
		float3(-0.35775623, -0.5301969, -0.43581226),
		float3(-0.3169221, 0.106360726, 0.015860917),
		float3(0.010350345, -0.58698344, 0.0046293875),
		float3(-0.08972908, -0.49408212, 0.3287904),
		float3(0.7119986, -0.0154690035, -0.09183723),
		float3(-0.053382345, 0.059675813, -0.5411899),
		float3(0.035267662, -0.063188605, 0.54602677),
		float3(-0.47761092, 0.2847911, -0.0271716)
	};

	float2 texelSize = float2(1.0f/timeAmpRtwRth.z, 1.0f/timeAmpRtwRth.w);
	float3 norm = normalize(tex5.Sample(TexSmpPointRepeat, uv*64.0).xyz*2.0 - 1.0);
	float currentDepth = linearizeDepthSample(uv);
	float radius = 6.0;//max(16.0 / currentDepth, 4.0);

	float4 final = float4(0.0, 0.0, 0.0, 0.0);
		for(int i=0; i < 16; i++)
		{
			float u = (float)i;
			float2 ray = normalize(reflect(norm, sphere[i]).xy);
				float2 offset = uv + ray.xy * texelSize * radius * (float(i)*(1.0/16.0));
				final += tex2.Sample(TexSmp, offset);
		}
		return final / 16.0;
}

float4 PSPostProcess_blurred( PS_IN input ) : SV_Target
{
	// NOTE - the uv offset should be weighted with z to get rid of the moire/noise you get with small/distant objects
	float2 uv = input.uv + (tex3.Sample(TexSmpRepeat, input.uv*0.21 + timeAmpRtwRth.xx*0.01).xy*0.2 - 0.1)*0.0005;

		float ux = 1.0f / timeAmpRtwRth.z;
	float uy = 1.0f / timeAmpRtwRth.w;
	float2 u = float2(0.5f*ux, 0.5f*uy);

		float4 sharp = blurBackbuffer(input.uv);

		float4 blur = tex.Sample(TexSmp, input.uv)*0.5 + tex.Sample(TexSmp, uv)*0.5;

		float4 glow = blur;
		glow.xyz -= float3(0.24f,0.245f,0.25f)*2.45f;
	if ( glow.x < 0.0f ) glow.x *= 0.8f;
	if ( glow.y < 0.0f ) glow.y *= 0.78f;
	if ( glow.z < 0.0f ) glow.z *= 0.79f;
	glow.xyz *= float3( 1.15f,1.05f,1.0f )*2.45f;
	glow.xyz += float3(0.24f,0.245f,0.25f)*2.65f;

	float4 noise = tex3.Sample(TexSmpRepeat, (input.uv+float2(timeAmpRtwRth.x*3.1, timeAmpRtwRth.x*0.1 ))); // noise
		float4 noise2 = tex3.Sample(TexSmpRepeat, (input.uv+float2(timeAmpRtwRth.x*3.2, timeAmpRtwRth.x*0.3 ))); // noise

		//float magnitude = edgeDetection(input.uv);
		float ssao = 1.0;//fakeSSAO(input.uv);
	// make ssao depend on glow intensity
	// ssao = ssao + (1.0 - ssao) * smoothstep(0.75, 1.0, length(glow.xyz));

	// TODO - use a constant to control where we get the defocus effect (eg something like uv2 = (input.uv - defocusCenter)*2.0 - 1.0)
	float2 uv2 = input.uv*2.0 - 1.0;
		// blend between sharp and blurred based on distance from screen center
		// NOTE - if we want to add more control we can take scene depth into account
		float blend = 1.0f; // smoothstep(0.0, 0.4, dot(uv2, uv2));

	float4 c;
	c.xyz = sharp.xyz*blend + blur.xyz*(1.0 - blend);// + magnitude*0.25;
	c.xyz *= (1.0f-ssao*1.5f)/3.0f + 0.66f;
	c.xyz *= (ssao) + 0.25f;
	c.w = 1.0f;
	c.xyz += glow*0.65f + (glow * noise)*0.10f;
	//	c.xyz += glow.xyz*0.65f + (glow.xyz * noise.xyz)*0.15f;

#define NEG 0.65f /*155f*/
	c.xyz -= float3(NEG,NEG,NEG);
	c.xyz *= 0.35f/(1.00-NEG);
	c.rgb *= scaleBias.rgb;
	c.rgb += float3(scaleBias.aaa);
	return c;
}

float2 from_hammer_aitoff(float2 pos)
{
#define PI    3.1415927
#define TWOPI 6.2831853
	float z = 1.0 - pos.x*pos.x/2.0 - pos.y*pos.y/2.0;
	float longitude = 2.0 * atan( sqrt(2.0) * pos.x * z / (2.0 * z * z - 1.0) );
	float latitude = asin( sqrt(2.0) * pos.y * z );
	return (float2(latitude/TWOPI, longitude/PI) + 1.0)*0.5;
}

float2 to_hammer_aitoff(float2 pos)
{
	float z = sqrt(1.0 + cos(pos.x) * cos(pos.y/2.0));
	float2 ha;
	ha.x = sin(pos.x) / z;
	ha.y = cos(pos.x)*sin(pos.y/2.0) / z;
	return (ha + 1.0) * 0.5;
}

float4 PSPostProcess_distorted( PS_IN input ) : SV_Target
{
	// NOTE - if you want to make the distortion effect less visible you can always lerp between the input.uv and the distorted uv
	//float2 inputuv = from_hammer_aitoff(input.uv*2.0 - 1.0);
	//inputuv = lerp(inputuv, input.uv, 0.75);
	float2 inputuv = to_hammer_aitoff(input.uv*float2(PI,TWOPI) - float2(PI/2.0,PI));
		inputuv = lerp(inputuv, input.uv, 0.5);
	// NOTE - the uv offset should be weighted with z to get rid of the moire/noise you get with small/distant objects
	float2 uv = inputuv + (tex3.Sample(TexSmpRepeat, input.uv*0.21 + timeAmpRtwRth.xx*0.01).xy*0.2 - 0.1)*0.0005;

		float ux = 1.0f / timeAmpRtwRth.z;
	float uy = 1.0f / timeAmpRtwRth.w;
	float2 u = float2(0.5f*ux, 0.5f*uy);

		float4 sharp = tex2.Sample(TexSmp, inputuv)*0.5 + tex2.Sample(TexSmp, uv + u)*0.5;
		float4 blur = tex.Sample(TexSmp, inputuv)*0.5 + tex.Sample(TexSmp, uv)*0.5;

		float4 glow = blur;
		glow.xyz -= float3(0.24f,0.245f,0.25f)*2.45f;
	if ( glow.x < 0.0f ) glow.x *= 0.8f;
	if ( glow.y < 0.0f ) glow.y *= 0.78f;
	if ( glow.z < 0.0f ) glow.z *= 0.79f;
	glow.xyz *= float3( 1.15f,1.05f,1.0f )*2.45f;
	glow.xyz += float3(0.24f,0.245f,0.25f)*2.65f;

	float4 noise = tex3.Sample(TexSmpRepeat, (inputuv+float2(timeAmpRtwRth.x*3.1, timeAmpRtwRth.x*0.1 ))); // noise
		float4 noise2 = tex3.Sample(TexSmpRepeat, (inputuv+float2(timeAmpRtwRth.x*3.2, timeAmpRtwRth.x*0.3 ))); // noise

		//float magnitude = edgeDetection(inputuv);
		float ssao = fakeSSAO(inputuv);
	// make ssao depend on glow intensity
	// ssao = ssao + (1.0 - ssao) * smoothstep(0.75, 1.0, length(glow.xyz));

	// TODO - use a constant to control where we get the defocus effect (eg something like uv2 = (input.uv - defocusCenter)*2.0 - 1.0)
	float2 uv2 = inputuv*2.0 - 1.0;
		// blend between sharp and blurred based on distance from screen center
		// NOTE - if we want to add more control we can take scene depth into account
		float blend = 1.0f; // smoothstep(0.0, 0.4, dot(uv2, uv2));

	float4 c;
	c.xyz = sharp.xyz*blend + blur.xyz*(1.0 - blend);// + magnitude*0.25;
	c.xyz *= (1.0f-ssao*1.5f)/3.0f + 0.66f;
	c.xyz *= (ssao) + 0.25f;
	c.w = 1.0f;
	c.xyz += glow.xyz*0.65f + (glow.xyz * noise.xyz)*0.15f;

#define NEG 0.65f /*155f*/
	c.xyz -= float3(NEG,NEG,NEG);
	c.xyz *= 0.35f/(1.00-NEG);
	c.rgb *= scaleBias.rgb;
	c.rgb += float3(scaleBias.aaa);
	return c;
}
#endif

struct VS_LIT_IN
{
	float3 pos : POSITION;
	float2 uv : TEXCOORD;
	float3 nrml : NORMAL;
	float4 cols : COLOR;
};

struct PSRenderLit_IN
{
	float4 pos : SV_POSITION;
	float3 uvw : TEXCOORD;
	float3 weights : NORMAL;
	float4 cols : COLOR;
};

PSRenderLit_IN VS_Lit( VS_LIT_IN input )
{
	float3 dl = float3( 1.0f, 1.0f, 1.0f );
		PSRenderLit_IN output = (PSRenderLit_IN)0;
	output.pos = mul( ModelViewProjectionMatrix, float4( input.pos, 1.0f) );

	float3x3 m3;

	m3._m00_m01_m02 = ModelViewMatrix._m00_m01_m02;
	m3._m10_m11_m12 = ModelViewMatrix._m10_m11_m12;
	m3._m20_m21_m22 = ModelViewMatrix._m20_m21_m22;
	transpose(m3);
	float3 nrm = mul( m3, input.nrml );
		dl = normalize( mul( m3, dl ) );
	nrm = normalize( nrm );
	float intensity = clamp(dot(dl, nrm), 0.1, 1.0) + clamp(dot(-dl, nrm), 0.1, 0.5);

	output.cols = input.cols * float4(1.0f, 1.05f, 1.025f, 1.0f) * clamp(intensity, 0.0, 1.0);
	output.cols.a = intensity;

	// cubic texture coord mapping
	float3 texCoordScale = float3(1.0, 1.0, 1.0) * 0.5; // NOTE - tweak this :)
		output.weights.x = abs( dot(input.nrml, float3(1.0, 0.0, 0.0)) );
	output.weights.y = abs( dot(input.nrml, float3(0.0, 1.0, 0.0)) );
	output.weights.z = abs( dot(input.nrml, float3(0.0, 0.0, 1.0)) );
	output.weights.xyz *= 1.0 / dot(output.weights, float3(1.0, 1.0, 1.0));
	output.uvw = input.pos * texCoordScale;

	return output;
}

float4 PSRenderLit( PSRenderLit_IN input, float4 screenPos : SV_Position ) : SV_Target
{
	float3 uvw = input.uvw;
		float4 detail =  tex.Sample(TexSmpRepeat, uvw.yz) * input.weights.x;
		detail += tex.Sample(TexSmpRepeat, uvw.xz) * input.weights.y;
	detail += tex.Sample(TexSmpRepeat, uvw.xy) * input.weights.z;

	uvw = uvw.zxy * 8.0;
	float4 detail2 =  tex.Sample(TexSmpRepeat, uvw.yz) * input.weights.x;
		detail2 += tex.Sample(TexSmpRepeat, uvw.xz) * input.weights.y;
	detail2 += tex.Sample(TexSmpRepeat, uvw.xy) * input.weights.z;
	detail += (detail2.x ) * 0.5;

	float4 c;
	c.xyz = input.cols * (detail.xyz*0.3 + 0.8);

	c.a = screenPos.z/screenPos.w;
	return c;
}

float4 PSRenderLaser( PSRenderLit_IN input, float4 screenPos : SV_Position ) : SV_Target
{
	float4 c = float4(1.0, 0.0, 0.0, 1.0);
		return c;
}

PS_IN VSKaareSol( VS_IN input )
{
	PS_IN output = (PS_IN)0;
	output.pos = float4( input.pos, 1.0f);
	output.uv = input.uv;
	return output;
}

float4 PSKaareSol( PS_IN input , float4 screenPos : SV_Position ) : SV_Target
{
	float3 r = float3(
		((screenPos.x-timeAmpRtwRth.z/2.0f)/timeAmpRtwRth.z),
		((screenPos.y-timeAmpRtwRth.w/2.0f)/timeAmpRtwRth.w),
		1.0f
		);

	float3 sp = float3( 10.0f, 10.0f, 10.0f );
		float3 floor = normalize(float3( -1.0f, -1.0f, -1.0f ));
		float3x3 m3;

	m3._m00_m01_m02 = ModelViewMatrix._m00_m01_m02;
	m3._m10_m11_m12 = ModelViewMatrix._m10_m11_m12;
	m3._m20_m21_m22 = ModelViewMatrix._m20_m21_m22;
	//m3= transpose(m3);
	sp = mul( m3, sp );
	floor = mul( m3, floor );
	// r = normalize(r);
	//	float r2 = dot(r,r);
	//	float t = (sp.x*r.x + sp.y *r.y + sp.z * r.z)/r2;

	//	float3 dp = r*t-sp;
	float d = 0.0f;
	//    float d = 100.0f/dot(dp, dp);
	//    if ( t < 0.0f ) d = 0.0f;

	float3 rs = r;
	float fog = 0.0f;
	for (int  i = 0;  i < 10;  i++)
	{
		d += sunBlurOverlay.x/dot( rs-sp, rs-sp );
		rs += (100.0/10.0f) * r;
		float tmp = (dot(rs,floor)+100.0f)/800.0f ;
		if ( tmp < 0.0f ) tmp = 0.0f;
		fog += tmp;
		if ( fog > 1.0f ) fog = 1.0f;
	}
	/*	tr-sp dot r = 0
	(t*r.x-sp.x, t*r.y - sp.y) dot (rx,ry) = 0
	(t*r.x-sp.x)*r.x + (t*r.y-sp.y)*r.y = 0
	t*r.x*r.x-sp.x*r.x + t*r.y*r.y-sp.y*r.y = 0
	t = (sp.x*r.x + sp.y*r.y) / (r.x*r.x + r.y*r.y)
	*/
	float4 c;
	c.r = d*1.83+(0.231f*fog)+(1.0f-fog)*(0.54f);
	c.g = d*1.75f+(0.235f*fog)+(1.0f-fog)*(0.24f);
	c.b = d*1.0f+(0.232f*fog)+(1.0f-fog)*(0.24f);
	c.a = 1.0f;

	return c;
}

technique11 RenderLit
{
	pass P0
	{
		SetBlendState( SolidBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthOn, 0 );
		SetRasterizerState( letsDoSomeCullingOK );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS_Lit() ) );
		SetPixelShader( CompileShader( ps_4_0, PSRenderLit() ) );
	}
}

technique11 RenderLaserTorpedo
{
	pass P0
	{
		SetBlendState( AdditiveBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthWriteOff, 0 );
		SetRasterizerState( letsDoSomeCullingOK );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS_Lit() ) );
		SetPixelShader( CompileShader( ps_4_0, PSRenderLaser() ) );
	}
}

technique11 KaareSol
{
	pass P0
	{
		SetBlendState(AdditiveBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthOff, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VSKaareSol() ) );
		SetPixelShader( CompileShader( ps_4_0, PSKaareSol() ) );
	}
}

technique11 Render
{
	pass P0
	{
		SetBlendState( SolidBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthOn, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}

technique11 SeparableGlowDownSample
{
	pass P0
	{
		SetBlendState( SolidBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthOff, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PSSeparableGlowDownSample() ) );
	}
}

technique11 SeparableGlowLastPass
{
	pass P0
	{
		SetBlendState( AdditiveBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthOff, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PSSeparableGlowLastPass() ) );
	}
}

technique11 PostProcess
{
	pass P0
	{
		SetBlendState( SolidBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthOff, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PSPostProcess_testing() ) );
	}
}

technique11 PostProcess_grey
{
	pass P0
	{
		SetBlendState( SolidBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthOff, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PSPostProcess_grey() ) );
	}
}


technique11 Outline
{
	pass P0
	{
		SetBlendState( SolidBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthOff, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PSPostProcess_outline() ) );
	}
}

technique11 PostProcessDistorted
{
	pass P0
	{
		SetBlendState( SolidBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthOff, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		//SetPixelShader( CompileShader( ps_4_0, PSPostProcess_testing() ) );
		SetPixelShader( CompileShader( ps_4_0, PSPostProcess_distorted() ) );
	}
}

technique11 PostProcessBlurred
{
	pass P0
	{
		SetBlendState( SolidBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthOff, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		//SetPixelShader( CompileShader( ps_4_0, PSPostProcess_testing() ) );
		SetPixelShader( CompileShader( ps_4_0, PSPostProcess_blurred() ) );
	}
}

technique11 SeparableGlowH
{
	pass P0
	{
		SetBlendState( SolidBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthOff, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PSSeparableGlowH() ) );
	}
}

technique11 SeparableGlowV
{
	pass P0
	{
		SetBlendState( SolidBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthOff, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PSSeparableGlowV() ) );
	}
}

technique11 Particles
{
	pass P0
	{
		SetBlendState( AdditiveBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthWriteOff, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VSParticles() ) );
		SetPixelShader( CompileShader( ps_4_0, PSParticles() ) );
	}
}

technique11 Explosions
{
	pass P0
	{
		SetBlendState( AdditiveBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthWriteOff, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VSExplosions() ) );
		SetPixelShader( CompileShader( ps_4_0, PSExplosions() ) );
	}
}

technique11 Scroller
{
	pass P0
	{
		SetBlendState( AdditiveBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthOff, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PSScroller() ) );
	}
}

float4 PSShowDepth( PS_IN input, float4 pos : SV_Position ) : SV_Target
{
	//	float nz = 1.0f-(pos.z/pos.w-nearFarZ.x)/(nearFarZ.y-nearFarZ.x);
	float nz = pos.z/pos.w;
	return float4(nz,nz,nz,1.0f);
}

technique11 ShowDepth
{
	pass P0
	{
		SetBlendState( SolidBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthOff, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PSShowDepth() ) );
	}
}

technique11 Overlay
{
	pass P0
	{
		SetBlendState( AdditiveBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthWriteOff, 0 );
		SetRasterizerState( alwaysDraw );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VSKaareSol() ) );
		SetPixelShader( CompileShader( ps_4_0, PSOverlay() ) );
	}
}